<?php
/**
 * Admin
 *
 * @package     AutomatorWP\Integrations\Twitter\Admin
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Shortcut function to get plugin options
 *
 * @since  1.0.0
 *
 * @param string    $option_name
 * @param bool      $default
 *
 * @return mixed
 */
function automatorwp_twitter_get_option( $option_name, $default = false ) {

    $prefix = 'automatorwp_twitter_';

    return automatorwp_get_option( $prefix . $option_name, $default );
}

/**
 * Register plugin settings sections
 *
 * @since  1.0.0
 *
 * @return array
 */
function automatorwp_twitter_settings_sections( $automatorwp_settings_sections ) {

    $automatorwp_settings_sections['twitter'] = array(
        'title' => __( 'Twitter', 'automatorwp-pro' ),
        'icon' => 'dashicons-twitter',
    );

    return $automatorwp_settings_sections;

}
add_filter( 'automatorwp_settings_sections', 'automatorwp_twitter_settings_sections' );

/**
 * Register plugin settings meta boxes
 *
 * @since  1.0.0
 *
 * @return array
 */
function automatorwp_twitter_settings_meta_boxes( $meta_boxes )  {

    $prefix = 'automatorwp_twitter_';

    $meta_boxes['automatorwp-twitter-settings'] = array(
        'title' => automatorwp_dashicon( 'twitter' ) . __( 'Twitter', 'automatorwp-pro' ),
        'fields' => apply_filters( 'automatorwp_twitter_settings_fields', array(
            $prefix . 'consumer_key' => array(
                'name' => __( 'API Key:', 'automatorwp-pro' ),
                'desc' => __( 'Your Twitter app API key.', 'automatorwp-pro' ),
                'type' => 'text',
            ),
            $prefix . 'consumer_secret' => array(
                'name' => __( 'API Key Secret:', 'automatorwp-pro' ),
                'desc' => __( 'Your Twitter app API key secret.', 'automatorwp-pro' ),
                'type' => 'text',
            ),
            $prefix . 'access_token' => array(
                'name' => __( 'Access Token:', 'automatorwp-pro' ),
                'desc' => __( 'Your Twitter app access token.', 'automatorwp-pro' ),
                'type' => 'text',
            ),
            $prefix . 'access_token_secret' => array(
                'name' => __( 'Access Token Secret:', 'automatorwp-pro' ),
                'desc' => __( 'Your Twitter app access token secret.', 'automatorwp-pro' ),
                'type' => 'text',
            ),
            $prefix . 'twitter_authorize' => array(
                'type' => 'text',
                'render_row_cb' => 'automatorwp_twitter_authorize_display_cb',
            ),
        ) ),
    );

    return $meta_boxes;

}
add_filter( "automatorwp_settings_twitter_meta_boxes", 'automatorwp_twitter_settings_meta_boxes' );

/**
 * Display callback for the authorize setting
 *
 * @since  1.0.0
 *
 * @param array      $field_args Array of field arguments.
 * @param CMB2_Field $field      The field object
 */
function automatorwp_twitter_authorize_display_cb( $field_args, $field ) {

    $access_valid = automatorwp_twitter_get_option( 'access_valid' );

    ?>

    <div class="cmb-row cmb-type-custom cmb2-id-automatorwp-twitter-authorize table-layout" data-fieldtype="custom">
        <div class="cmb-th">
            <label><?php echo __( 'Connect with Twitter:', 'automatorwp-pro' ); ?></label>
        </div>
        <div class="cmb-td">
            <input type="hidden" name="awp-twitter-outh-ajax-nonce" id="awp-twitter-outh-ajax-nonce" value="<?php echo wp_create_nonce( 'awp-outh-ajax-nonce' ); ?>" />           
            <input type="button" name="automatorwp_save_twitter_oauth" id="automatorwp_save_twitter_oauth" value="Save Credentials" class="button button-primary" />
            <?php if ( $access_valid ){ ?>
            <input type="button" name="automatorwp_remove_twitter_oauth" id="automatorwp_remove_twitter_oauth" value="Delete Credentials" class="button button-danger" /><br>
            <?php } ?>
            <p id='awp_twitter_oauth_status'></p>
        </div>
    </div>
    	
    <?php
}